Scriptname zBFSEffectsScript extends activemagiceffect  

;;;; ===================================================
;;; Official mod page: http://skyrim.nexusmods.com/mods/14692
;;;; ===================================================

;;; === Global ===
GlobalVariable property BFSEffectsActivated auto
GlobalVariable property BFSEffectsDebug auto
GlobalVariable property BFSEffectsWeapons auto
GlobalVariable property BFSEffectsPoison auto
GlobalVariable property BFSEffectsSteam auto

;;;; === BFS spells === 
Spell property BFSDeadSpell auto
Spell property FireSpell auto
Spell property FireCriticalSpell auto
Spell property FireRandomSpell auto
Spell property IceSpell auto
Spell property IceCriticalSpell auto
Spell property IceRandomSpell auto
Spell property ShockSpell auto
Spell property ShockCriticalSpell auto
Spell property ShockRandomSpell auto
Spell property ShockConvulsionSpell auto
Spell property PoisonRandomSpell auto
Spell property SteamRandomSpell auto

;;; === Effect shaders === (Not used since old version, but left here due to "cannot found property in script... in papyrus")
EffectShader property BurnedTexture auto
EffectShader property FireEffectShader auto
EffectShader property FireEffectShaderBig auto

EffectShader property SmokeFX auto
EffectShader property SmokesmallFX auto

EffectShader property CalcinatedTexture auto
EffectShader property ShockEffectShader auto
EffectShader property ShockEffectShaderSmall auto

EffectShader property IceEffectShader auto
EffectShader property FreezeTexture auto
EffectShader property FreezeTextureInstant auto

;;; === Master spells ===
Spell property Blizzard auto
Spell property HazardFrostBlizzardSpell03 auto
Spell property Firestorm auto
Spell property Lightningstorm auto

;;; === Shouts ===
Spell property VoiceFireBreath3 auto
Spell property VoiceFrostBreath3 auto
Spell property StormCallLightningBolt01 auto
Spell property StormCallLightningBolt02 auto
Spell property StormCallLightningBolt03 auto

;;; === BFS magic effects ===
MagicEffect property FireMagicEffect auto
MagicEffect property FireMagicCriticalEffect auto
MagicEffect property FireMagicRandomEffect auto
MagicEffect property IceMagicEffect auto
MagicEffect property IceMagicCriticalEffect auto
MagicEffect property IceMagicRandomEffect auto
MagicEffect property ShockMagicEffect auto
MagicEffect property ShockMagicCriticalEffect auto
MagicEffect property ShockMagicRandomEffect auto
MagicEffect property ShockConvulsionMagicEffect auto
MagicEffect property PoisonMagicRandomEffect auto
MagicEffect property SteamMagicRandomEffect auto

;;; === Enchantments ===
;;;Fire
MagicEffect property DA09EnchDawnbreakerEnchFireDamageFFContact auto
MagicEffect property dunRedEagleFireDamageFFContact auto
MagicEffect property EnchFireDamageFFContact auto
MagicEffect property EnchTrollsbaneFireDamageFFContact auto	;;; ActorTypeTroll

MagicEffect property RuneFireFFLocation auto

;;; Shock
MagicEffect property EnchShockDamageFFContact auto
MagicEffect property MQ203ExtraDamageFFContact auto

MagicEffect property RuneShockFFLocation auto

;;; Ice
MagicEffect property ChillrendEnchFrostDamageFFContact auto
MagicEffect property EnchFrostDamageFFContact auto

MagicEffect property RuneFrostFFLocation auto

;;;  === Traps ===
;;; Traps are detected by OnHit event but the script does not work, using OnMagicEffectApply fixes this
MagicEffect property HazardFireDamageFFContact auto
MagicEffect property TrapExplGasEnchFireDamageFFContact01 auto
MagicEffect property TrapExplGasEnchFireDamageFFContact02 auto
MagicEffect property TrapExplGasEnchFireDamageFFContact03 auto
MagicEffect property TrapExplGasEnchFireDamageFFContact04 auto
MagicEffect property TrapExplGasEnchFireDamageFFContact05 auto
MagicEffect property TrapExplGasEnchFireDamageFFContact06 auto
MagicEffect property TrapFireDamageConcAimed auto
MagicEffect property TrapFireDamageFFAimed auto
MagicEffect property TrapFireDamageFFAimedArea auto
MagicEffect property TrapFlamePillarMagicEffect01 auto
MagicEffect property TrapGenericFireMagicEffect01 auto
MagicEffect property TrapOilHazardFireDamageFFContact01 auto
MagicEffect property TrapOilHazardFireDamageFFContact02 auto
MagicEffect property TrapOilHazardFireDamageFFContact03 auto
MagicEffect property TrapOilHazardFireDamageFFContact04 auto
MagicEffect property TrapOilHazardFireDamageFFContact05 auto
MagicEffect property TrapOilHazardFireDamageFFContact06 auto
MagicEffect property TrapRuneFireFFLocation01 auto
MagicEffect property TrapRuneFireFFLocation02 auto
MagicEffect property TrapRuneFireFFLocation03 auto
MagicEffect property TrapRuneFireFFLocation04 auto
MagicEffect property TrapRuneFireFFLocation05 auto
MagicEffect property TrapRuneFireFFLocation06 auto

MagicEffect property TrapRuneLightningFFLocation01 auto
MagicEffect property TrapRuneLightningFFLocation02 auto
MagicEffect property TrapRuneLightningFFLocation03 auto
MagicEffect property TrapRuneLightningFFLocation04 auto
MagicEffect property TrapRuneLightningFFLocation05 auto
MagicEffect property TrapRuneLightningFFLocation06 auto
MagicEffect property TrapShockDamageConcAimed auto
MagicEffect property TrapShockDamageFFAimed auto
MagicEffect property TrapShockDamageFFAimedArea auto

MagicEffect property TrapRuneFrostFFLocation01 auto
MagicEffect property TrapRuneFrostFFLocation02 auto
MagicEffect property TrapRuneFrostFFLocation03 auto
MagicEffect property TrapRuneFrostFFLocation04 auto
MagicEffect property TrapRuneFrostFFLocation05 auto
MagicEffect property TrapRuneFrostFFLocation06 auto
MagicEffect property TrapFrostDamageConcAimed auto
MagicEffect property TrapFrostDamageFFAimed auto
MagicEffect property TrapFrostDamageFFAimedArea auto

;;; === Poison magic effects list ===
FormList property BFSEffectsPoisonList auto

;;; === Steam magic effects list ===
FormList property BFSEffectsSteamList auto


Keyword property MagicDamageFire auto
Keyword property MagicDamageFire01 auto
Keyword property MagicDamageFrost auto
Keyword property MagicDamageFrost01 auto
Keyword property MagicDamageShock auto
Keyword property MagicDamageShock01 auto

Keyword property ActorTypeTroll auto

Actor target
Float BFSActive
Float BFSDebug
Float BFSWeapons
Float BFSPoison
Float BFSSteam

Auto STATE BFS
EVENT OnEffectStart(Actor akTarget, Actor akCaster)
	target = akTarget
EndEvent


EVENT OnHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)
BFSGetValues()
 if (BFSActive == 0)	
	;; Don't allow to continue if mod is not active, when deactivated the zBFSEffectsSpell on npcs is still active for 60 sec until it expires
	return
 endif

;;; akSource as Explosion is also detected but the scrolls that use explosion don't apply the effects, normal spells with explosions work checking for Spell or OnMagicEffectApply()
;;; akSource as Weapon is detected by Torch and weapons, but it messes up level 3 shouts. Weapon enchantments are defined in OnMagicEffectApply()
;;; akSource as Scroll never triggers, need to find a way to make scrolls working
 if (akSource as Spell) || (akSource as Enchantment)
	;Debug.Notification("BFS akSource valid")
 else
	return
 endif

GoToState("Busy") ; Don't run this function again until it's finished

  if akAggressor != NONE && target != NONE && akSource != NONE && target.Is3DLoaded()
	if (akSource == Firestorm  || akSource == VoiceFireBreath3)
		if !target.HasMagicEffect(FireMagicCriticalEffect)
			FireCriticalSpell.Cast(akAggressor, target)
			if (BFSDebug == 1)
				Debug.Notification("Fire critical")
			endif
		endif
	elseif (akSource == Lightningstorm || akSource == StormCallLightningBolt01 || akSource == StormCallLightningBolt02 || akSource == StormCallLightningBolt03)
		if !target.HasMagicEffect(ShockMagicCriticalEffect)
			ShockCriticalSpell.Cast(akAggressor, target)
			if (BFSDebug == 1)
				Debug.Notification("Shock critical")
			endif
		endif
	elseif (akSource == Blizzard || akSource == HazardFrostBlizzardSpell03 || akSource == VoiceFrostBreath3)
		if !target.HasMagicEffect(IceMagicCriticalEffect)
			IceCriticalSpell.Cast(akAggressor, target)
			if (BFSDebug == 1)
				Debug.Notification("Ice critical")
			endif
		endif
	elseif (akSource.HasKeyword(MagicDamageFire) || akSource.HasKeyword(MagicDamageFire01))
		if !target.HasMagicEffect(FireMagicEffect)
			FireSpell.Cast(akAggressor, target)
			if (BFSDebug == 1)
				Debug.Notification("Fire normal")
			endif
		endif
	elseif (akSource.HasKeyword(MagicDamageShock) || akSource.HasKeyword(MagicDamageShock01))
		if !target.HasMagicEffect(ShockMagicEffect)
			ShockSpell.Cast(akAggressor, target)
			if (BFSDebug == 1)
				Debug.Notification("Shock normal")
			endif
		endif
	elseif (akSource.HasKeyword(MagicDamageFrost) || akSource.HasKeyword(MagicDamageFrost01))
		if !target.HasMagicEffect(IceMagicEffect)
			IceSpell.Cast(akAggressor, target)
			if (BFSDebug == 1)
				Debug.Notification("Ice normal")
			endif
		endif	
	endif
  endif

GoToState("BFS") ; The function has finished, so it can be called again

EndEvent


EVENT OnMagicEffectApply(ObjectReference akCaster, MagicEffect akEffect)
BFSGetValues()
if (BFSActive == 0)	
	;; Don't allow to continue if mod is not active, when deactivated the zBFSEffectsSpell on npcs is still active for 60 sec until it expires
	return
endif

GoToState("Busy") ; Don't run this function again until it's finished

  if target != NONE	;;; checking for akCaster != NONE makes the traps not working
	if akEffect == EnchFireDamageFFContact || akEffect == DA09EnchDawnbreakerEnchFireDamageFFContact || akEffect == dunRedEagleFireDamageFFContact || akEffect == RuneFireFFLocation || (akEffect == EnchTrollsbaneFireDamageFFContact && target.HasKeyword(ActorTypeTroll))
			if (BFSDebug == 1)
				Debug.Notification("Fire enchantment")
			endif
		if (BFSWeapons == 1)
			if !target.HasMagicEffect(FireMagicEffect)
				FireSpell.Cast(akCaster, target)
			endif
		elseif (BFSWeapons == 2)
			if !target.HasMagicEffect(FireMagicRandomEffect)
				FireRandomSpell.Cast(target, target)
			endif
		endif
	elseif akEffect == EnchShockDamageFFContact || akEffect == MQ203ExtraDamageFFContact || akEffect == RuneShockFFLocation
			if (BFSDebug == 1)
				Debug.Notification("Shock enchantment")
			endif
		if (BFSWeapons == 1)
			if !target.HasMagicEffect(ShockMagicEffect)
				ShockSpell.Cast(akCaster, target)
			endif
		elseif (BFSWeapons == 2)
			if !target.HasMagicEffect(ShockMagicRandomEffect)
				ShockRandomSpell.Cast(target, target)
			endif
		endif
	elseif akEffect == ChillrendEnchFrostDamageFFContact || akEffect == EnchFrostDamageFFContact || akEffect == RuneFrostFFLocation
			if (BFSDebug == 1)
				Debug.Notification("Ice enchantment")
			endif
		if (BFSWeapons == 1)
			if !target.HasMagicEffect(IceMagicEffect)
				IceSpell.Cast(akCaster, target)
			endif
		elseif (BFSWeapons == 2)
			if !target.HasMagicEffect(IceMagicRandomEffect)
				IceRandomSpell.Cast(target, target)
			endif
		endif
	;;;;; === Traps ===
	;;; Fire normal
	elseif akEffect == TrapExplGasEnchFireDamageFFContact01 || akEffect == TrapExplGasEnchFireDamageFFContact02 || akEffect == TrapExplGasEnchFireDamageFFContact03 || akEffect == TrapExplGasEnchFireDamageFFContact04 \
	|| akEffect == TrapFireDamageConcAimed || akEffect == TrapFireDamageFFAimed || akEffect == TrapFireDamageFFAimedArea ||  akEffect == TrapFlamePillarMagicEffect01 ||  akEffect == TrapGenericFireMagicEffect01 \
	|| akEffect == TrapOilHazardFireDamageFFContact01 ||  akEffect == TrapOilHazardFireDamageFFContact02 ||  akEffect == TrapOilHazardFireDamageFFContact03 ||  akEffect == TrapOilHazardFireDamageFFContact04 \
	||  akEffect == TrapRuneFireFFLocation01 ||  akEffect == TrapRuneFireFFLocation02 ||  akEffect == TrapRuneFireFFLocation03 ||  akEffect == TrapRuneFireFFLocation04
		if !target.HasMagicEffect(FireMagicRandomEffect)
			FireRandomSpell.Cast(target, target)
			if (BFSDebug == 1)
				Debug.Notification("Fire trap normal")
			endif
		endif
	;;; Torch & plate pressure traps
	elseif akEffect == HazardFireDamageFFContact		;; sometimes Fire Spells call this event instead of fire normal or critical ?
		if !target.HasMagicEffect(FireMagicRandomEffect)
			FireRandomSpell.Cast(target, target)
			if (BFSDebug == 1)
				Debug.Notification("Torch or plate")
			endif
		endif
	;;; Fire Critical
	elseif akEffect == TrapExplGasEnchFireDamageFFContact05 || akEffect == TrapExplGasEnchFireDamageFFContact06 \
	|| akEffect == TrapOilHazardFireDamageFFContact05 ||  akEffect == TrapOilHazardFireDamageFFContact06 \
	||  akEffect == TrapRuneFireFFLocation05 ||  akEffect == TrapRuneFireFFLocation06
		if !target.HasMagicEffect(FireMagicCriticalEffect)
			FireCriticalSpell.Cast(target, target)
			if (BFSDebug == 1)
				Debug.Notification("Fire trap critical")
			endif
		endif

	;;; Shock normal
	elseif akEffect == TrapRuneLightningFFLocation01 || akEffect == TrapRuneLightningFFLocation02 || akEffect == TrapRuneLightningFFLocation03 || akEffect == TrapRuneLightningFFLocation04 \
	|| akEffect == TrapShockDamageConcAimed || akEffect == TrapShockDamageFFAimed || akEffect == TrapShockDamageFFAimedArea
		if !target.HasMagicEffect(ShockMagicRandomEffect)
			ShockRandomSpell.Cast(target, target)
			if (BFSDebug == 1)
				Debug.Notification("Shock trap normal")
			endif
		endif
	;;; Shock Critical
	elseif akEffect == TrapRuneLightningFFLocation05 || akEffect == TrapRuneLightningFFLocation06
		if !target.HasMagicEffect(ShockMagicCriticalEffect)
			ShockCriticalSpell.Cast(target, target)
			if (BFSDebug == 1)
				Debug.Notification("Shock trap critical")
			endif
		endif

	;;; Ice normal
	elseif akEffect == TrapRuneFrostFFLocation01 || akEffect == TrapRuneFrostFFLocation02 || akEffect == TrapRuneFrostFFLocation03 || akEffect == TrapRuneFrostFFLocation04 \
	|| akEffect == TrapFrostDamageConcAimed || akEffect == TrapFrostDamageFFAimed || akEffect == TrapFrostDamageFFAimedArea
		if !target.HasMagicEffect(IceMagicRandomEffect)
			IceRandomSpell.Cast(target, target)
			if (BFSDebug == 1)
				Debug.Notification("Ice trap normal")
			endif
		endif
	;;; Ice Critical
	elseif akEffect == TrapRuneFrostFFLocation05 || akEffect == TrapRuneFrostFFLocation06
		if !target.HasMagicEffect(IceMagicCriticalEffect)
			IceCriticalSpell.Cast(target, target)
			if (BFSDebug == 1)
				Debug.Notification("Ice trap critical")
			endif
		endif
	endif

	;;; Poison
	if BFSEffectsPoisonList != NONE && BFSPoison != 0
		if BFSEffectsPoisonList.HasForm(akEffect)
			if !target.HasMagicEffect(PoisonMagicRandomEffect)
				PoisonRandomSpell.Cast(target, target)
				if (BFSDebug == 1)
					Debug.Notification("Poison damage")
				endif
			endif
		endif
	endif
	;;; Steam
	if BFSEffectsSteamList != NONE && BFSSteam == 1
		if BFSEffectsSteamList.HasForm(akEffect)
			if !target.HasMagicEffect(SteamMagicRandomEffect)
				SteamRandomSpell.Cast(target, target)
				if (BFSDebug == 1)
					Debug.Notification("Steam damage")
				endif
			endif
		endif
	endif

  endif
GoToState("BFS") ; The function has finished, so it can be called again

EndEvent
ENDSTATE


Function BFSGetValues()
	if (BFSEffectsActivated != NONE)
		BFSActive = BFSEffectsActivated.GetValue()
	endif
	if (BFSEffectsDebug != NONE)
		BFSDebug = BFSEffectsDebug.GetValue()
	endif
	if (BFSEffectsWeapons != NONE)
		BFSWeapons = BFSEffectsWeapons.GetValue()
	endif
	if (BFSEffectsPoison != NONE)
		BFSPoison = BFSEffectsPoison.GetValue()
	endif
	if (BFSEffectsSteam != NONE)
		BFSSteam = BFSEffectsSteam.GetValue()
	endif
endfunction


STATE Busy
EVENT OnHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)
	; Do nothing
EndEvent

EVENT OnMagicEffectApply(ObjectReference akCaster, MagicEffect akEffect)
	; Do nothing
EndEvent
ENDSTATE